/*
 * Decompiled with CFR 0.152.
 */
package com.muchsoft.util;

public class Sys {
    private static final boolean ismacos;
    private static final boolean ismacosx;
    private static final boolean islinux;
    private static final boolean iswindows;
    private static final boolean isos2;
    private static final String homeDir;
    private static final String workDir;
    private static final String prefDir;
    private static final String localPrefDir;
    private static final String javaHome;

    private Sys() {
    }

    public static boolean isMacOS() {
        return ismacos;
    }

    public static boolean isMacOSX() {
        return ismacosx;
    }

    public static boolean isAMac() {
        return ismacosx || ismacos;
    }

    public static boolean isLinux() {
        return islinux;
    }

    public static boolean isWindows() {
        return iswindows;
    }

    public static boolean isOS2() {
        return isos2;
    }

    public static String getHomeDirectory() {
        return homeDir;
    }

    public static String getWorkingDirectory() {
        return workDir;
    }

    public static String getPrefsDirectory() {
        return prefDir;
    }

    public static String getLocalPrefsDirectory() {
        return localPrefDir;
    }

    public static String getJavaHome() {
        return javaHome;
    }

    public static void main(String[] stringArray) {
        System.out.println();
        System.out.println("** com.muchsoft.util.Sys version 2004-10-13");
        System.out.println("**");
        System.out.println("** JavaHome:   " + Sys.getJavaHome());
        System.out.println("** AppWork:    " + Sys.getWorkingDirectory());
        System.out.println("** UserHome:   " + Sys.getHomeDirectory());
        System.out.println("** UserPrefs:  " + Sys.getPrefsDirectory());
        System.out.println("** LocalPrefs: " + Sys.getLocalPrefsDirectory());
        System.out.println("**");
        System.out.print("** System:     ");
        if (Sys.isMacOSX()) {
            System.out.println("Mac OS X");
        } else if (Sys.isMacOS()) {
            System.out.println("Mac OS 8/9");
        } else if (Sys.isLinux()) {
            System.out.println("Linux");
        } else if (Sys.isWindows()) {
            System.out.println("Windows");
        } else if (Sys.isOS2()) {
            System.out.println("OS/2");
        } else {
            System.out.println("unknown");
        }
        System.out.println("**             " + System.getProperty("os.name"));
        System.out.println("** Java:       " + System.getProperty("java.version"));
        System.out.println("**             " + System.getProperty("java.runtime.version"));
        System.out.println("**             " + System.getProperty("java.vm.version"));
        System.out.println("**             " + System.getProperty("java.vendor"));
        System.out.println("** MRJ:        " + System.getProperty("mrj.version"));
        System.out.println();
    }

    static {
        homeDir = System.getProperty("user.home");
        workDir = System.getProperty("user.dir");
        String string = System.getProperty("os.name");
        String string2 = System.getProperty("java.vendor");
        String string3 = System.getProperty("java.home");
        ismacosx = string.toLowerCase().startsWith("mac os x");
        ismacos = !ismacosx && (string2.indexOf("Apple") >= 0 || string.indexOf("Mac OS") >= 0);
        islinux = string.indexOf("Linux") >= 0;
        iswindows = string.indexOf("Windows") >= 0;
        boolean bl = isos2 = string.indexOf("OS/2") >= 0;
        if (ismacosx) {
            String string4 = homeDir + "/Library/Preferences";
            String string5 = "/Library/Preferences";
            prefDir = string4;
            localPrefDir = string5;
            if (string3 == null || string3.length() == 0) {
                string3 = "/Library/Java/Home";
            }
        } else {
            prefDir = homeDir;
            localPrefDir = islinux ? "/etc" : workDir;
        }
        javaHome = string3;
    }
}

